/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
#ifdef CONFIG_NSS

#include <Shark-gpl.h>

#include <linux/types.h>
#include <linux/kernel.h>
#include <asm/uaccess.h>
#include <asm/unistd.h>

#include <cxiTypes.h>
#include <cxiCred-plat.h>

#ifndef __SYSFUN_DEFS
#define __SYSFUN_DEFS
extern long sys_call_table[];
typedef asmlinkage long (*sysfun_long_p)();
typedef asmlinkage int (*sysfun_int_p)();
#endif

static asmlinkage int (*oldsys_setgroups32)(int gidsetsize, gid_t *grouplist);
static asmlinkage int (*oldsys_setgroups16)(int gidsetsize, old_gid_t *grouplist);

static int cred_setgroups32(int gidsetsize, gid_t *grouplist) 
{
  gid_t top[2];
	
  if (HAS_PAG(current->groups)) {
    if (gidsetsize < 2)
      goto override_setgroups;
    if (copy_from_user(top, grouplist, 2 * sizeof(gid_t)))
      return -EFAULT;
    if (HAS_PAG(top))
      goto old_setgroups;
  } else {
    goto old_setgroups;
  }

 override_setgroups:
  if (!capable(CAP_SETGID))
    return -EPERM;
  if (((unsigned)gidsetsize) + 2 > NGROUPS)
    return -EINVAL;
  if(copy_from_user(&current->groups[2], grouplist, gidsetsize * sizeof(gid_t)))
    return -EFAULT;
  current->ngroups = gidsetsize + 2;
  return 0;
  
 old_setgroups:
  return oldsys_setgroups32(gidsetsize, grouplist);
}

static int cred_setgroups16(int gidsetsize, old_gid_t *grouplist) 
{
  old_gid_t top[2];
  old_gid_t gids[NGROUPS-2];
  int i;

  if (HAS_PAG(current->groups)) {
    if (gidsetsize < 2)
      goto override_setgroups;
    if (copy_from_user(top, grouplist, 2 * sizeof(old_gid_t)))
      return -EFAULT;
    if (HAS_PAG(top))
      goto old_setgroups;
  } else {
    goto old_setgroups;
  }

 override_setgroups:
  if (!capable(CAP_SETGID))
    return -EPERM;
  if (((unsigned)gidsetsize) + 2 > NGROUPS)
    return -EINVAL;
  if (copy_from_user(gids, grouplist, gidsetsize * sizeof(old_gid_t)))
    return -EFAULT;
  for (i = 0; i < gidsetsize; i++)
    current->groups[i+2] = (gid_t)gids[i];
  current->ngroups = gidsetsize + 2;
  return 0;
  
 old_setgroups:
  return oldsys_setgroups16(gidsetsize, grouplist);
}

void cred_init(void) 
{
  oldsys_setgroups32 = (sysfun_int_p)sys_call_table[__NR_setgroups32];
  sys_call_table[__NR_setgroups32] = (long)&cred_setgroups32;
  oldsys_setgroups16 = (sysfun_int_p)sys_call_table[__NR_setgroups];
  sys_call_table[__NR_setgroups] = (long)&cred_setgroups16;
}

void cred_cleanup(void) {
#ifdef XXXX
  nss_pag_t *cur, *nxt;
  int i;
#endif

  if (sys_call_table[__NR_setgroups] != (long)&cred_setgroups16 ||
      sys_call_table[__NR_setgroups32] != (long)&cred_setgroups32) {
    printk("Error unloading cred_setgroups\n");
  }
  sys_call_table[__NR_setgroups32] = (long)oldsys_setgroups32;
  sys_call_table[__NR_setgroups] = (long)oldsys_setgroups16;

#ifdef XXXX
  for (i = 0; i < PAG_HASH_SIZE; i++) {
    cur = pags[i];
    while (cur) {
      nxt = cur->next_pag;
      kfree(cur);
      cur = nxt;
    }
  }
#endif
}

#endif /* CONFIG_NSS */
